#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform vec2 iResolution;
uniform float iGlobalTime;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 iMouse = vec4(0.0);
float smin( float a, float b, float k ){
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}

mat3 rotY(in float a) {
    return mat3( cos(a), 0.0, sin(a),
                 0.0,    1.0, 0.0,
                -sin(a), 0.0, cos(a)
                );
}
float sdTorus( vec3 p, float i){
    vec2 t=vec2(p.x*0.38+1.4,0.064+0.001*p.z);
    vec2 q = vec2(length(p.xz)-t.x,p.y);
    return length(q)-t.y;
}
float udRoundBox( vec3 p, vec3 b, float r ){
  return length(max(abs(p)-b,0.0))-r;
}
float rand(vec2 co)
{
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float scene(vec3 pos){
    float tulos=2.;
    for(float i=0.; i<18.; i++){
        float ballDist =  (mod(i+iGlobalTime,22.));
        vec3 ballPos = ballDist*vec3(rand(vec2(i))-.5,rand(vec2(i+8.))-.5,rand(vec2(i+11.))-.5);
        tulos = smin(tulos, sdSphere(pos-ballPos, ballDist*0.1),8.8);
    }
    tulos = smin(tulos, sdSphere(pos, 0.4),5.8);
    return tulos*0.48;
}
vec3 march(vec3 cam, vec3 dir){
    vec3 matka=vec3(0.0);
    vec3 kohta;
    for (int i=0;i<33;i++){
        kohta=0.5*matka*dir+cam;
        float etaisyys= scene(kohta);
        matka+=etaisyys;
    }
    vec2 D = vec2(atan(dir.x,dir.z)/3.141 + iGlobalTime*0.1,dir.y);
    matka*=0.7+texture(iChannel0,D).rgb*0.1;
    return sqrt(matka)*(0.5+(0.6+matka)*floor(mod(kohta.y+iGlobalTime*30.0,2.0)));
}

vec3 vaerita(in vec3 f){
    float t = 1.1*log(1.1+(length(clamp(f, 0.0, 1.0))-0.4)*1.7);
    vec3 r;
    r.g = 0.7;
    r.r = 0.8-0.2+0.5*t + r.g*0.8+smoothstep(0.2, 0.8, t);
    r.b = 0.1-0.9*t;
    return smoothstep(0.0, 1.0, 0.5*r+0.2);
}
float sun(vec2 coord, vec2 pos, float size){
    if(length(coord-pos)<size)
        return 1.0;
    return 0.0;
}

float time=0.;
vec4 mainImage( vec2 fragCoord ){
    vec2 uv = fragCoord.xy / iResolution.xy*2.0-1.0;
    uv.y*=iResolution.y/iResolution.x;

    uv*=1.0+rand(uv+iGlobalTime+.8)/(pow(iGlobalTime+.8,7.0)*3.0)-length(uv)*10.0/(pow(1.8*iGlobalTime+.8,24.0));
    float t=iGlobalTime;
    float aikaout=mod(t,8.6);
    vec3 cam=vec3(0.,0.,-6.+sin(iGlobalTime*0.2)*4.);
    
    vec3 dir=normalize(vec3(uv,1.0));
    dir *= (cos(uv.x)+cos(uv.y));
    
    cam *= rotY(iGlobalTime*1.1+10.0*floor(iGlobalTime*0.25));
    dir *= rotY(iGlobalTime*1.07+10.0*floor(iGlobalTime*0.25));
    cam.yzx *= rotY(iGlobalTime*1.38+10.0*floor(iGlobalTime*0.25));
    dir.yzx *= rotY(iGlobalTime*1.4+10.0*floor(iGlobalTime*0.25));
    vec2 q = vec2( sin(0.5*uv.x),sin(0.5*uv.y) );
    float a = atan(q.y,q.x);
    float r = sqrt(dot(q,q));
    
    vec3 color=1.-0.23*vec3(march( cam, dir));
    color = color+0.3*vaerita(color);
    color = smoothstep(0.02, 0.8, color);

    float ressu=0.;
    float vignette = 1. / (26.225 + 0.4*dot(uv, uv));
    
    return vec4( color-vignette*.27, 1.0);
}



void main() {
  vec2 uv = gl_FragCoord.xy / iResolution.xy*2.0-1.0;
  vec4 fragColor;
  gl_FragColor = (3.0*mainImage( gl_FragCoord.xy ) + 0.3*vec4((1.3*rand(vec2(floor(gl_FragCoord*4.0*iGlobalTime))))))*(1.-length(gl_FragCoord.xy/iResolution.xy-.5)/1.62);
}